/*
 ********************************************************************
 *
 * rieglapi.h - the API for the LynxOS Riegl LMS device driver
 *
 *     CSIRO Automation
 *     Queensland Centre for Advanced Technologies
 *     PO Box 883, Kenmore, QLD 4069, Australia
 *     www.cat.csiro.au/cmst
 *
 *	$Id: rieglapi.h,v 1.2 2003/11/11 11:09:07 kp Exp $
 *
 * Copyright (c) CSIRO Manufacturing Science & Technology
 *
 ********************************************************************
 */
/**
 ********************************************************************
 *
 * \file rieglapi.h
 * \brief API for the Riegl LMS LynxOS device driver
 * \author Pavan Sikka
 *
 ********************************************************************
 */

#ifndef __rieglapi_h__
#define __rieglapi_h__

#ifdef __cplusplus
    extern "C" {
#endif

#include <string.h>
#include <sys/time.h>
      
#define RIEGL_DATA_FORMAT_RANGE       0x0001
#define RIEGL_DATA_FORMAT_AMPLITUDE   0x0004
#define RIEGL_DATA_FORMAT_ANGLE       0x0008
#define RIEGL_DATA_FORMAT_QUALITY     0x0020
#define RIEGL_DATA_FORMAT_DELAY       0x0040
      
#define MAX_NUM_DATA_POINTS       1024
      
      typedef struct _riegl_header {
	// preamble block
	unsigned int       dwSize;	 // size of header, including this word
	unsigned short     wBytesPerLine;// number of bytes per line of data
	unsigned char      bProtocolID;	// 1
	unsigned char      bHeaderID;	// 10
	
	// main block
	unsigned short     wMeasOffset;	// 0
	unsigned short     wMeasSize;	// bytes per point
	unsigned short     wMeasCount;	// points per line
	unsigned char      bLeadInIDMain;	// 0
	unsigned short     wLeadinIDSub;	// 0
	unsigned char      bMeasIDMain;	// 28
	unsigned short     wMeasIDSub;	// data provided bit mask (F command)
	unsigned char      bTrailerIDMain;	// 0
	unsigned short     wTrailerIDSub;	// 0
	unsigned char      bParameterIDMain;// 3
	unsigned short     wParameterIDSub;	// 0
	
	// parameter block
	unsigned char	SerialNumber[8];// unit serial number
	float		fRangeUnit;	// range scale factor
	float		fAngleUnit;	// angle scale factor
	float		fTimerUnit;	// time scale factor
	unsigned char	AngleID;	// 3
      } RIEGL_HEADER;
      
      typedef struct _riegl_datapoint {
	float     range;           /* m */
	char      amplitude;       /* 0-255 */
	char      quality;         /* 0-100 */
	float     angle;           /* radians */
	float     delay;           /* seconds */
      } RIEGL_DATA_POINT;
      
      typedef struct _riegl_scanline {
	short     synchSequence;
	short     numPoints;
	struct timeval scanTime;
	RIEGL_DATA_POINT point[MAX_NUM_DATA_POINTS];
      } RIEGL_SCAN_LINE;
      
      typedef struct _riegl {
	int                		fd;
	RIEGL_HEADER       		header;
	unsigned char		*buf;	// for raw line data
      } RIEGL;
      
      RIEGL * riegl_open (const char * devName);
      int riegl_read (RIEGL * rp, 
		      RIEGL_DATA_POINT *scan, 
		      struct timeval *time);
      void riegl_print_header ( RIEGL * rp);
      int riegl_close (RIEGL * rp);
      void riegl_print_scan (RIEGL * rp, RIEGL_DATA_POINT *pp);
      
#ifdef __cplusplus
    }
#endif

#endif
