/*
 * Telecom Clock driver for Wainwright board
 *
 * Copyright (C) 2005 Kontron Canada
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 * NON INFRINGEMENT.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send feedback to <sebastien.bouchard@ca.kontron.com>
 *
 */
 
/* Ioctl definitions  */

/* Use 0xA1 as magic number */
#define TLCLK_IOC_MAGIC 0xA1

/*Hardware Reset of the PLL */

#define RESET_ON 0x00
#define RESET_OFF 0x01
#define IOCTL_RESET _IO(TLCLK_IOC_MAGIC,  1)

#define IOCTL_REFALIGN _IO(TLCLK_IOC_MAGIC,  2)

/* MODE SELECT */

#define NORMAL_MODE 0x00
#define HOLDOVER_MODE 0x10
#define FREERUN_MODE 0x20

#define IOCTL_MODE_SELECT _IOR(TLCLK_IOC_MAGIC,  3, char)

/* FILTER SELECT */

#define FILTER_6HZ 0x04
#define FILTER_12HZ 0x00

#define IOCTL_FILTER_SELECT _IOR(TLCLK_IOC_MAGIC,  4, char)

/* SELECT REFERENCE FREQUENCY */

#define REF_CLK1_8kHz 0x00
#define REF_CLK2_19_44MHz 0x02

#define IOCTL_SELECT_REF_FREQUENCY _IOR(TLCLK_IOC_MAGIC,  6, char)

/* Select primary or secondary redundant clock */

#define PRIMARY_CLOCK 0x00
#define SECONDARY_CLOCK 0x01
#define IOCTL_SELECT_REDUNDANT_CLOCK _IOR(TLCLK_IOC_MAGIC,  7, char)

/* CLOCK TRANSMISSION DEFINE */

#define CLK_8kHz 0xff
#define CLK_16_384MHz 0xfb

#define CLK_1_544MHz 0x00
#define CLK_2_048MHz 0x01
#define CLK_4_096MHz 0x02
#define CLK_6_312MHz 0x03
#define CLK_8_192MHz 0x04
#define CLK_19_440MHz 0x06

#define CLK_8_592MHz 0x08
#define CLK_11_184MHz 0x09
#define CLK_34_368MHz 0x0b
#define CLK_44_736MHz 0x0a

#define IOCTL_SELECT_AMCB1_TRANSMIT_CLOCK _IOR(TLCLK_IOC_MAGIC,  9, char)
#define IOCTL_SELECT_AMCB2_TRANSMIT_CLOCK _IOR(TLCLK_IOC_MAGIC,  10, char)

/* RECEIVED REFERENCE */

#define AMC_B1 0
#define AMC_B2 1

#define IOCTL_SELECT_RECEIVED_REF_CLK3A _IOR(TLCLK_IOC_MAGIC,  11, char)
#define IOCTL_SELECT_RECEIVED_REF_CLK3B _IOR(TLCLK_IOC_MAGIC,  12, char)

/* OEM COMMAND - NOT IN FINAL VERSION */

#define IOCTL_TEST_MODE _IO(TLCLK_IOC_MAGIC,  13)

/* HARDWARE SWITCHING DEFINE */

#define HW_ENABLE 0x80
#define HW_DISABLE 0x00

#define IOCTL_HARDWARE_SWITCHING _IOR(TLCLK_IOC_MAGIC,  14, char)

/* HARDWARE SWITCHING MODE DEFINE */

#define PLL_HOLDOVER 0x40
#define LOST_CLOCK 0x00

#define IOCTL_HARDWARE_SWITCHING_MODE _IOR(TLCLK_IOC_MAGIC,  15, char)

/* CLOCK OUTPUT DEFINE */

#define IOCTL_ENABLE_CLKA0_OUTPUT _IOR(TLCLK_IOC_MAGIC,  16, char)
#define IOCTL_ENABLE_CLKB0_OUTPUT _IOR(TLCLK_IOC_MAGIC,  17, char)
#define IOCTL_ENABLE_CLKA1_OUTPUT _IOR(TLCLK_IOC_MAGIC,  18, char)
#define IOCTL_ENABLE_CLKB1_OUTPUT _IOR(TLCLK_IOC_MAGIC,  19, char)

#define IOCTL_ENABLE_CLK3A_OUTPUT _IOR(TLCLK_IOC_MAGIC,  20, char)
#define IOCTL_ENABLE_CLK3B_OUTPUT _IOR(TLCLK_IOC_MAGIC,  21, char)

/* ALARMS DEFINE */

#define UNLOCK_MASK 0x10
#define HOLDOVER_MASK 0x20
#define SEC_LOST_MASK 0x40
#define PRI_LOST_MASK 0x80

#define IOCTL_READ_ALARMS _IO(TLCLK_IOC_MAGIC,  22)

/* INTERRUPT CAUSE DEFINE */

#define PRI_LOS_01_MASK 0x01
#define PRI_LOS_10_MASK 0x02

#define SEC_LOS_01_MASK 0x04
#define SEC_LOS_10_MASK 0x08

#define HOLDOVER_01_MASK 0x10
#define HOLDOVER_10_MASK 0x20

#define UNLOCK_01_MASK 0x40
#define UNLOCK_10_MASK 0x80

#define IOCTL_READ_INTERRUPT_SWITCH _IO(TLCLK_IOC_MAGIC,  23)

#define IOCTL_READ_CURRENT_REF _IO(TLCLK_IOC_MAGIC,  25)

/* MAX NUMBER OF IOCTL */
#define TLCLK_IOC_MAXNR 25

struct tlclk_alarms {
	unsigned int lost_clocks;
	unsigned int lost_primary_clock;
	unsigned int lost_secondary_clock;
	unsigned int primary_clock_back;
	unsigned int secondary_clock_back;
	unsigned int switchover_primary;
	unsigned int switchover_secondary;
	unsigned int pll_holdover;
	unsigned int pll_end_holdover;
	unsigned int pll_lost_sync;
	unsigned int pll_sync;
};

